<?php

// Make sure we can't access this file directly from the browser.
if(!defined('IN_MYBB'))
{
    die('This file cannot be accessed directly.');
}

// cache templates - this is important when it comes to performance
// THIS_SCRIPT is defined by some of the MyBB scripts, including index.php
if(defined('THIS_SCRIPT'))
{
    global $templatelist;

    if(isset($templatelist))
    {
        $templatelist .= ',';
    }

    if(THIS_SCRIPT== 'index.php')
    {
        $templatelist .= 'krakenaudio_index, krakenaudio_message';
    }
    elseif(THIS_SCRIPT== 'showthread.php')
    {
        $templatelist .= 'krakenaudio_post, krakenaudio_message';
    }
}

if(defined('IN_ADMINCP'))
{
    // Add our hello_settings() function to the setting management module to load language strings.
    $plugins->add_hook('admin_config_settings_manage', 'krakenaudio_settings');
    $plugins->add_hook('admin_config_settings_change', 'krakenaudio_settings');
    $plugins->add_hook('admin_config_settings_start', 'krakenaudio_settings');
    // We could hook at 'admin_config_settings_begin' only for simplicity sake.
}
else
{
    // Add our hello_index() function to the index_start hook so when that hook is run our function is executed
//    $plugins->add_hook('index_start', 'krakenaudio_index');

    // Add our hello_post() function to the postbit hook so it gets executed on every post
    $plugins->add_hook('postbit', 'krakenaudio_post');

    // Add our hello_new() function to the misc_start hook so our misc.php?action=hello inserts a new message into the created DB table.
//    $plugins->add_hook('misc_start', 'krakenaudio_new');
}
function krakenaudio_info()
{
    return array(
        "name"  => "KrakenFiles.com audio player",
        "description"=> "Convert all krakenfiles.com link to audio player in posts",
        "website"        => "https://krakenfiles.com",
        "author"        => "KrakenFiles.com",
        "authorsite"    => "https://krakenfiles.com",
        "version"        => "1.0",
        "guid"             => "",
        "compatibility" => "18*"
    );
}

function krakenaudio_deactivate()
{
    global $db;
        $db->delete_query('settings', "name='krakenaudio_enable'");
        $db->delete_query('settings', "name='krakenaudio_download'");
        $db->delete_query('settings', "name='krakenaudio_onlyregister'");
        $db->delete_query('settinggroups', "name='krakenaudio'");
}

function krakenaudio_activate()
{
    global $db;

    // Settings group array details
    $group = array(
        'name' => 'krakenaudio',
        'title' => 'KrakenFiles.com audio player',
        'description' => 'Settings For KrakenFiles.com audio player',
        'isdefault' => 0
    );

    // Check if the group already exists.
    $query = $db->simple_select('settinggroups', 'gid', "name='krakenaudio'");

    if($gid = (int)$db->fetch_field($query, 'gid'))
    {
        // We already have a group. Update title and description.
        $db->delete_query('settinggroups',  "gid='{$gid}'");
    }

    else
    {
        // We don't have a group. Create one with proper disporder.
        $query = $db->simple_select('settinggroups', 'MAX(disporder) AS disporder');
        $disporder = (int)$db->fetch_field($query, 'disporder');

        $group['disporder'] = ++$disporder;

        $gid = (int)$db->insert_query('settinggroups', $group);
    }

    // add settings
    $settings = array(
        'display1'	=>  array(
            'sid'            => 'NULL',
            'name'        => 'krakenaudio_enable',
            'title'            => 'Enable KrakenFiles.com audio player?',
            'description'    => 'If you set this option to yes, this plugin be active on your board.',
            'optionscode'    => 'yesno',
            'value'        => '1',
            'disporder'        => 1,
            'gid'            => intval($gid),
        ),
        'display2' => array(
            'sid'            => 'NULL',
            'name'        => 'krakenaudio_download',
            'title'            => 'Show download link',
            'description'    => 'If you set this option to yes, download link to KrakenFiles.com will be show under audio player',
            'optionscode'    => 'yesno',
            'value'        => '1',
            'disporder'        => 2,
            'gid'            => intval($gid),
        ),
        'display3' => array(
            'sid'            => 'NULL',
            'name'        => 'krakenaudio_onlyregister',
            'title'            => 'Only logged users can see download link',
            'description'    => 'If you set this option to yes, Only logged user seen download link under player',
            'optionscode'    => 'yesno',
            'value'        => '1',
            'disporder'        => 3,
            'gid'            => intval($gid),
        ),
        'display4' => array(
            'sid'            => 'NULL',
            'name'        => 'krakenaudio_width',
            'title'            => 'Width of audio player',
            'description'    => 'Set width in pixels to show audio player',
            'optionscode'    => 'text',
            'value'        => '450',
            'disporder'        => 4,
            'gid'            => intval($gid),
        ));


    // Create and/or update settings.
    foreach($settings as $key => $setting)
    {
            $db->insert_query('settings', $setting);
    }

    // This is required so it updates the settings.php file as well and not only the database - they must be synchronized!
    rebuild_settings();
}

/*
 * Loads the settings language strings.
*/
function krakenaudio_settings()
{
    global $lang;

    // Load our language file
}

function krakenaudio_post(&$post)
{
    global $settings, $mybb;
    // Only run this function is the setting is set to yes
    if($settings['krakenaudio_enable'] != 1)
    {
        return;
    }

    preg_match_all("/\[kr\](.*)https:\/\/krakenfiles.com\/view\/([a-zA-Z0-9]*)\/file.html(.*)\[\/kr\]/", $post['message'], $matches, PREG_SET_ORDER);

    if ($matches) {
        $krakendownbutt = '';
        $krakenwidth = (int)$settings['krakenaudio_width'];
        $krakenauto = 'false';
        $userLogged = true;

        if ($settings['krakenaudio_download'] == '1') {
            $krakenDownloadButtonAvailable = true;

            if ($settings['krakenaudio_onlyregister'] == '1' && $mybb->user['username'] == '') {
                $userLogged = false;
            }
        }

        foreach ($matches as $data) {

            $krakenlink = str_replace(['[kr]', '[/kr]'], '', $data[0]);
            $krakenfile = $data[2];

            $cache = $mybb->cache->read('krakenaudio');

            if (date('d.m.Y') != $cache['time']) {
                $mybb->cache->delete('krakenaudio');
            }
            $cache['time'] = date('d.m.Y');

            if (isset($cache[$krakenfile])) {
                $infoData = json_decode($cache[$krakenfile], true);
            } else {
                $dataJson = file_get_contents('https://krakenfiles.com/json/' . $krakenfile);
                $infoData = json_decode($dataJson, true);
                $cache[$krakenfile] = $dataJson;
                $mybb->cache->update('krakenaudio', $cache);
            }

            if ($infoData['type'] != 'music') {
                return;
            }

            if ($krakenDownloadButtonAvailable) {
                if ($userLogged) {
                    $krakendownbutt = 'Download: '.$krakenlink;
                } else {
                    $krakendownbutt = '<span style="color:red">Download only for logged users. Please <a href="/member.php?action=login">login</a> or <a href="member.php?action=register">register</a></span>';
                }
                $post['message'] = str_replace($data[0], '<script type="text/javascript">var hash="' . $infoData['hash'] . '"; var date="' . $infoData['uploadDate'] . '"; var server ="' . $infoData['server'] . '"; var autoPlay="' . $krakenauto . '";  var width="' . $krakenwidth . '";</script><script type="text/javascript" src="//krakenfiles.com/js/player/embed.js"></script>'
                    . '<br>' . $krakendownbutt . '<br>', $post['message']);
            } // No download button
            else {
                $post['message'] = str_replace($data[0], '<script type="text/javascript">var hash="' . $infoData['hash'] . '"; var date="' . $infoData['uploadDate'] . '"; var server ="' . $infoData['server'] . '"; var autoPlay="' . $krakenauto . '";  var width="' . $krakenwidth . '";</script><script type="text/javascript" src="//krakenfiles.com/js/player/embed.js"></script>', $post['message']);
            }
        }
    }
}


?>
